# Generated by Django 4.2.23 on 2025-07-21 15:05

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("university_structure", "0001_initial"),
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="last login"
                    ),
                ),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        error_messages={
                            "unique": "A user with that username already exists."
                        },
                        help_text="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.",
                        max_length=150,
                        unique=True,
                        validators=[
                            django.contrib.auth.validators.UnicodeUsernameValidator()
                        ],
                        verbose_name="username",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="first name"
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="last name"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="email address"
                    ),
                ),
                (
                    "is_staff",
                    models.BooleanField(
                        default=False,
                        help_text="Designates whether the user can log into this admin site.",
                        verbose_name="staff status",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this user should be treated as active. Unselect this instead of deleting accounts.",
                        verbose_name="active",
                    ),
                ),
                (
                    "date_joined",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="date joined"
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                        related_name="custom_user_groups_set",
                        related_query_name="user",
                        to="auth.group",
                        verbose_name="groups",
                    ),
                ),
                (
                    "user_permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Specific permissions for this user.",
                        related_name="custom_user_permissions_set",
                        related_query_name="user",
                        to="auth.permission",
                        verbose_name="user permissions",
                    ),
                ),
            ],
            options={
                "verbose_name": "مستخدم",
                "verbose_name_plural": "المستخدمون",
            },
            managers=[
                ("objects", django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name="FacultyProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "first_name_ar",
                    models.CharField(max_length=100, verbose_name="الاسم الأول (عربي)"),
                ),
                (
                    "second_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الثاني (عربي)"
                    ),
                ),
                (
                    "third_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الثالث (عربي)"
                    ),
                ),
                (
                    "fourth_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الرابع (عربي)"
                    ),
                ),
                (
                    "first_name_en",
                    models.CharField(
                        max_length=100, verbose_name="First Name (English)"
                    ),
                ),
                (
                    "second_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Second Name (English)"
                    ),
                ),
                (
                    "third_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Third Name (English)"
                    ),
                ),
                (
                    "fourth_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Fourth Name (English)"
                    ),
                ),
                (
                    "employee_id",
                    models.CharField(
                        max_length=20, unique=True, verbose_name="رقم الموظف"
                    ),
                ),
                (
                    "is_registrar",
                    models.BooleanField(default=False, verbose_name="مسجل عام"),
                ),
                (
                    "position",
                    models.CharField(
                        choices=[
                            ("Professor", "أستاذ"),
                            ("Associate Professor", "أستاذ مشارك"),
                            ("Assistant Professor", "أستاذ مساعد"),
                            ("Lecturer", "محاضر"),
                            ("Instructor", "معيد"),
                            ("Admin Staff", "موظف إداري"),
                            ("Head of Department", "رئيس قسم"),
                            ("Dean", "عميد كلية"),
                            ("Registrar", "مسجل عام"),
                            ("Finance Officer", "مسؤول مالي"),
                            ("System Administrator", "مسؤول نظام"),
                        ],
                        max_length=50,
                        verbose_name="الوظيفة",
                    ),
                ),
                ("hire_date", models.DateField(verbose_name="تاريخ التعيين")),
                (
                    "contact_phone",
                    models.CharField(
                        blank=True, max_length=20, null=True, verbose_name="رقم الهاتف"
                    ),
                ),
                (
                    "contact_email",
                    models.EmailField(
                        max_length=254,
                        unique=True,
                        verbose_name="البريد الإلكتروني للعمل",
                    ),
                ),
                ("is_active", models.BooleanField(default=True, verbose_name="نشط")),
                (
                    "college",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="faculty_members",
                        to="university_structure.college",
                        verbose_name="الكلية",
                    ),
                ),
                (
                    "department",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="faculty_members",
                        to="university_structure.department",
                        verbose_name="القسم",
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="faculty_profile",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="حساب المستخدم",
                    ),
                ),
            ],
            options={
                "verbose_name": "ملف هيئة تدريس/موظف",
                "verbose_name_plural": "ملفات هيئة التدريس والموظفين",
            },
        ),
    ]
