# users/admin.py

from django.contrib import admin
from django.contrib.auth.admin import UserAdmin # Import Django's default UserAdmin
from .models import User, FacultyProfile # Import your custom User and FacultyProfile models

# Register your custom User model with the existing UserAdmin
# This makes your User model appear in the Django admin interface.
@admin.register(User)
class CustomUserAdmin(UserAdmin):
    # If you added custom fields to your User model (beyond AbstractUser's defaults),
    # you would list them here in fieldsets or add_fieldsets.
    # For now, we are just using AbstractUser's built-in fields.
    pass # Uses default UserAdmin behavior for AbstractUser-based model

# Register FacultyProfile as well
@admin.register(FacultyProfile)
class FacultyProfileAdmin(admin.ModelAdmin):
    list_display = ('user_username', 'full_name_ar', 'employee_id', 'department', 'position', 'is_active', 'is_registrar') # Added is_registrar
    search_fields = ('user__username', 'employee_id', 'first_name_ar', 'fourth_name_ar', 'contact_email')
    list_filter = ('department', 'position', 'is_active', 'college', 'is_registrar') # Added is_registrar filter
    raw_id_fields = ('user', 'department', 'college') # Useful for selecting related objects via ID

    def user_username(self, obj):
        return obj.user.username if obj.user else 'N/A'
    user_username.short_description = "اسم المستخدم"

    def full_name_ar(self, obj):
        return f"{obj.first_name_ar} {obj.second_name_ar} {obj.third_name_ar} {obj.fourth_name_ar}"
    full_name_ar.short_description = "الاسم الكامل (عربي)"