from django.shortcuts import render

# Create your views here.
# university_structure/views.py

from rest_framework import viewsets
from .models import AcademicYear, AcademicSemester, College, Department, Batch, UniversityConfiguration
from .serializers import (
    AcademicYearSerializer, AcademicSemesterSerializer, CollegeSerializer,
    DepartmentSerializer, BatchSerializer, UniversityConfigurationSerializer
)

class AcademicYearViewSet(viewsets.ModelViewSet):
    queryset = AcademicYear.objects.all().order_by('year')
    serializer_class = AcademicYearSerializer

class AcademicSemesterViewSet(viewsets.ModelViewSet):
    queryset = AcademicSemester.objects.all().order_by('academic_year__year', 'semester_number')
    serializer_class = AcademicSemesterSerializer

class CollegeViewSet(viewsets.ModelViewSet):
    queryset = College.objects.all().order_by('name_ar')
    serializer_class = CollegeSerializer

class DepartmentViewSet(viewsets.ModelViewSet):
    queryset = Department.objects.all().order_by('college__name_ar', 'name_ar')
    serializer_class = DepartmentSerializer

class BatchViewSet(viewsets.ModelViewSet):
    queryset = Batch.objects.all().order_by('academic_year__year', 'department__name_ar')
    serializer_class = BatchSerializer

class UniversityConfigurationViewSet(viewsets.ModelViewSet):
    queryset = UniversityConfiguration.objects.all()
    serializer_class = UniversityConfigurationSerializer

    # Optional: Override create to ensure only one instance can be created via API
    def create(self, request, *args, **kwargs):
        if UniversityConfiguration.objects.exists():
            return Response({"detail": "Only one UniversityConfiguration instance can exist."}, status=status.HTTP_400_BAD_REQUEST)
        return super().create(request, *args, **kwargs)

    # Optional: Override destroy to prevent deletion via API if desired
    def destroy(self, request, *args, **kwargs):
        # You might want to disallow deleting this singleton through the API
        return Response({"detail": "Deletion of UniversityConfiguration is not allowed via API."}, status=status.HTTP_405_METHOD_NOT_ALLOWED)