# university_structure/urls.py

from django.urls import path, include
from rest_framework.routers import DefaultRouter
from .views import (
    AcademicYearViewSet, AcademicSemesterViewSet, CollegeViewSet,
    DepartmentViewSet, BatchViewSet, UniversityConfigurationViewSet
)

router = DefaultRouter()
router.register(r'academic-years', AcademicYearViewSet)
router.register(r'academic-semesters', AcademicSemesterViewSet)
router.register(r'colleges', CollegeViewSet)
router.register(r'departments', DepartmentViewSet)
router.register(r'batches', BatchViewSet)
router.register(r'university-config', UniversityConfigurationViewSet) # For singleton configuration

urlpatterns = [
    path('', include(router.urls)),
]