# ums_project/university_structure/serializers.py

from rest_framework import serializers
from .models import AcademicYear, AcademicSemester, College, Department, Batch, UniversityConfiguration
from users.models import FacultyProfile # Ensure this is imported

# This DepartmentSerializer is used by DepartmentViewSet AND now potentially nested.
# It should include all necessary fields.
class DepartmentSerializer(serializers.ModelSerializer):
    college_name_ar = serializers.CharField(source='college.name_ar', read_only=True)
    college_name_en = serializers.CharField(source='college.name_en', read_only=True)
    head_name_ar = serializers.CharField(source='head.full_name_ar', read_only=True, allow_null=True)
    head_name_en = serializers.CharField(source='head.full_name_en', read_only=True, allow_null=True)

    class Meta:
        model = Department
        fields = '__all__' # Includes all fields for CRUD and nesting


class CollegeSerializer(serializers.ModelSerializer):
    dean_name_ar = serializers.CharField(source='dean.full_name_ar', read_only=True, allow_null=True)
    dean_name_en = serializers.CharField(source='dean.full_name_en', read_only=True, allow_null=True)
    
    # This is the key change: Nest the DepartmentSerializer
    # 'departments' is the related_name from Department's ForeignKey to College
    departments = DepartmentSerializer(many=True, read_only=True) 

    class Meta:
        model = College
        fields = '__all__' # Will now include the 'departments' field


class AcademicYearSerializer(serializers.ModelSerializer):
    class Meta:
        model = AcademicYear
        fields = '__all__'

class AcademicSemesterSerializer(serializers.ModelSerializer):
    academic_year_name = serializers.CharField(source='academic_year.year', read_only=True)
    class Meta:
        model = AcademicSemester
        fields = '__all__'

class BatchSerializer(serializers.ModelSerializer):
    department_name = serializers.CharField(source='department.name_ar', read_only=True)
    academic_year_name = serializers.CharField(source='academic_year.year', read_only=True)
    class Meta:
        model = Batch
        fields = '__all__'

class UniversityConfigurationSerializer(serializers.ModelSerializer):
    current_academic_year_name = serializers.CharField(source='current_academic_year.year', read_only=True)
    current_semester_name_ar = serializers.CharField(source='current_semester.name_ar', read_only=True)
    current_semester_name_en = serializers.CharField(source='current_semester.name_en', read_only=True)

    class Meta:
        model = UniversityConfiguration
        fields = '__all__'