# Generated by Django 4.2.23 on 2025-07-21 15:05

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("university_structure", "0001_initial"),
        ("users", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="department",
            name="head",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="head_of_department",
                to="users.facultyprofile",
                verbose_name="رئيس القسم",
            ),
        ),
        migrations.AddField(
            model_name="college",
            name="dean",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="dean_of_college",
                to="users.facultyprofile",
                verbose_name="العميد",
            ),
        ),
        migrations.AddField(
            model_name="batch",
            name="academic_year",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="batches",
                to="university_structure.academicyear",
                verbose_name="السنة الأكاديمية",
            ),
        ),
        migrations.AddField(
            model_name="batch",
            name="department",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="batches",
                to="university_structure.department",
                verbose_name="القسم",
            ),
        ),
        migrations.AddField(
            model_name="academicsemester",
            name="academic_year",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="semesters",
                to="university_structure.academicyear",
                verbose_name="السنة الأكاديمية",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="department",
            unique_together={("college", "code")},
        ),
        migrations.AlterUniqueTogether(
            name="batch",
            unique_together={("department", "academic_year")},
        ),
        migrations.AlterUniqueTogether(
            name="academicsemester",
            unique_together={("academic_year", "semester_number")},
        ),
    ]
