# Generated by Django 4.2.23 on 2025-07-21 15:05

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="AcademicSemester",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name_ar",
                    models.CharField(max_length=50, verbose_name="اسم الفصل (عربي)"),
                ),
                (
                    "name_en",
                    models.CharField(max_length=50, verbose_name="اسم الفصل (إنجليزي)"),
                ),
                ("semester_number", models.IntegerField(verbose_name="رقم الفصل")),
                ("start_date", models.DateField(verbose_name="تاريخ البدء")),
                ("end_date", models.DateField(verbose_name="تاريخ الانتهاء")),
                (
                    "registration_start_date",
                    models.DateField(verbose_name="بداية التسجيل"),
                ),
                (
                    "registration_end_date",
                    models.DateField(verbose_name="نهاية التسجيل"),
                ),
                (
                    "grade_entry_start_date",
                    models.DateField(verbose_name="بداية إدخال الدرجات"),
                ),
                (
                    "grade_entry_end_date",
                    models.DateField(verbose_name="نهاية إدخال الدرجات"),
                ),
                (
                    "is_active",
                    models.BooleanField(default=False, verbose_name="نشط حالياً"),
                ),
            ],
            options={
                "verbose_name": "فصل دراسي",
                "verbose_name_plural": "فصول دراسية",
            },
        ),
        migrations.CreateModel(
            name="AcademicYear",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "year",
                    models.CharField(
                        max_length=9, unique=True, verbose_name="السنة الأكاديمية"
                    ),
                ),
                ("start_date", models.DateField(verbose_name="تاريخ البدء")),
                ("end_date", models.DateField(verbose_name="تاريخ الانتهاء")),
                (
                    "is_active",
                    models.BooleanField(default=False, verbose_name="نشطة حالياً"),
                ),
            ],
            options={
                "verbose_name": "سنة أكاديمية",
                "verbose_name_plural": "سنوات أكاديمية",
            },
        ),
        migrations.CreateModel(
            name="Batch",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, verbose_name="اسم الدفعة")),
                ("start_year", models.IntegerField(verbose_name="سنة البدء")),
                (
                    "end_year",
                    models.IntegerField(
                        blank=True, null=True, verbose_name="سنة الانتهاء المتوقعة"
                    ),
                ),
                ("is_active", models.BooleanField(default=True, verbose_name="نشطة")),
            ],
            options={
                "verbose_name": "دفعة طلابية",
                "verbose_name_plural": "دفعات طلابية",
            },
        ),
        migrations.CreateModel(
            name="College",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name_ar",
                    models.CharField(max_length=255, verbose_name="اسم الكلية (عربي)"),
                ),
                (
                    "name_en",
                    models.CharField(
                        max_length=255, verbose_name="اسم الكلية (إنجليزي)"
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        max_length=20, unique=True, verbose_name="كود الكلية"
                    ),
                ),
                (
                    "contact_info",
                    models.TextField(blank=True, verbose_name="معلومات الاتصال"),
                ),
            ],
            options={
                "verbose_name": "كلية",
                "verbose_name_plural": "كليات",
            },
        ),
        migrations.CreateModel(
            name="UniversityConfiguration",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="اسم الجامعة")),
                (
                    "current_academic_year",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="current_university_config",
                        to="university_structure.academicyear",
                        verbose_name="السنة الأكاديمية الحالية",
                    ),
                ),
                (
                    "current_semester",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="current_university_config",
                        to="university_structure.academicsemester",
                        verbose_name="الفصل الدراسي الحالي",
                    ),
                ),
            ],
            options={
                "verbose_name": "إعدادات الجامعة",
                "verbose_name_plural": "إعدادات الجامعة",
            },
        ),
        migrations.CreateModel(
            name="Department",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name_ar",
                    models.CharField(max_length=255, verbose_name="اسم القسم (عربي)"),
                ),
                (
                    "name_en",
                    models.CharField(
                        max_length=255, verbose_name="اسم القسم (إنجليزي)"
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        max_length=20, unique=True, verbose_name="كود القسم"
                    ),
                ),
                (
                    "contact_info",
                    models.TextField(blank=True, verbose_name="معلومات الاتصال"),
                ),
                (
                    "college",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="departments",
                        to="university_structure.college",
                        verbose_name="الكلية",
                    ),
                ),
            ],
            options={
                "verbose_name": "قسم",
                "verbose_name_plural": "أقسام",
            },
        ),
    ]
