from django.contrib import admin

# Register your models here.
# university_structure/admin.py

from django.contrib import admin
from .models import AcademicYear, AcademicSemester, College, Department, Batch, UniversityConfiguration

admin.site.register(AcademicYear)
admin.site.register(AcademicSemester)
admin.site.register(College)
admin.site.register(Department)
admin.site.register(Batch)

# Custom Admin for UniversityConfiguration to ensure only one instance can be created/edited
@admin.register(UniversityConfiguration)
class UniversityConfigurationAdmin(admin.ModelAdmin):
    def has_add_permission(self, request):
        # Allow adding only if no instance exists
        return not UniversityConfiguration.objects.exists()

    def has_delete_permission(self, request, obj=None):
        # Allow deleting only if there's an instance
        return UniversityConfiguration.objects.exists() and obj is not None