

# ums_project/urls.py

from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from django.conf.urls.i18n import i18n_patterns # Import i18n_patterns
from rest_framework.authtoken.views import obtain_auth_token # 
from django.views.generic.base import RedirectView
# Define your urlpatterns within i18n_patterns
# This will automatically add the language prefix (e.g., /ar/, /en/)
# to all URLs defined inside it.
urlpatterns = i18n_patterns(
    path('', RedirectView.as_view(url='admin/', permanent=True)),
    path('admin/', admin.site.urls),
    path('api/', include('users.urls')),
    path('api/', include('university_structure.urls')),
    path('api/', include('student_management.urls')),
    path('api/', include('course_management.urls')),
    path('api/', include('finance_management.urls')),
    path('api/', include('examination_management.urls')),
    path('api/auth-token/', obtain_auth_token),
)

# --- Serve media files in development ---
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
# If you have any URLs that should NOT be translated (e.g., media files, static files),
# you can add them outside i18n_patterns. For now, we don't have any.
# from django.conf import settings
# from django.conf.urls.static import static
# if settings.DEBUG:
#     urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)