"""
Django settings for ums_project project.

Generated by 'django-admin startproject' using Django 4.2.23.

For more information on this file, see
https://docs.djangoproject.com/en/4.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/4.2/ref/settings/
"""

from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/4.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = "django-insecure-3o*o0rwr_8s*7^l-@7&(#1cl9r#=vr4^*=3w9q!ds)_9g4u*_o"

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    "users.apps.UsersConfig",
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "corsheaders",  
    "rest_framework", 
    'rest_framework.authtoken',
    "django_filters",
   "university_structure",
    "student_management",
    "course_management",
    "finance_management",
    "examination_management",
    
]
# Tell Django to use your custom user model
AUTH_USER_MODEL = 'users.User' # This specifies your custom user model
MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    'corsheaders.middleware.CorsMiddleware',
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.locale.LocaleMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
    
]

ROOT_URLCONF = "ums_project.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

WSGI_APPLICATION = "ums_project.wsgi.application"


# Database
# https://docs.djangoproject.com/en/4.2/ref/settings/#databases

#DATABASES = {
 #   "default": {
  #      "ENGINE": "django.db.backends.sqlite3",
   #     "NAME": BASE_DIR / "db.sqlite3",
    #}
#}
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql',
        'NAME': 'ums_db',           # Your database name
        'USER': 'ums_user',         # Your database user
        'PASSWORD': 'umsp@ss', # Your database password
        'HOST': 'localhost',        # Or the IP address of your PostgreSQL server
        'PORT': '5433',                 # Leave empty for default (5432)
    }
}

# Password validation
# https://docs.djangoproject.com/en/4.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
    },
]


# Internationalization
# https://docs.djangoproject.com/en/4.2/topics/i18n/

LANGUAGE_CODE = "ar"
LANGUAGES = [
    ('ar', 'العربية'),
    ('en', 'English'),
]

TIME_ZONE = "UTC"

USE_I18N = True

USE_TZ = True


USE_L10N = True # Enable Django's localization for data formatting (e.g., numbers, dates).



# Define where Django looks for translation files
LOCALE_PATHS = [
    BASE_DIR / 'locale', # Django will look for translation files in a 'locale' directory at the project root
]
# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/4.2/howto/static-files/

STATIC_URL = "static/"

# Default primary key field type
# https://docs.djangoproject.com/en/4.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = "django.db.models.BigAutoField"
CORS_ALLOW_ALL_ORIGINS = False
CORS_ALLOWED_ORIGINS = [
"http://localhost:5173", # Your React app's URL
"http://127.0.0.1:5173", 
"http://localhost:8001",
]
ALLOWED_HOSTS = [
    'localhost',
    '127.0.0.1',
    'ums.tatbigia.edu.sd'
]
CORS_ALLOW_CREDENTIALS = False  
CSRF_COOKIE_HTTPONLY = True  
# Or, for quick development (less secure):
#CORS_ALLOW_ALL_ORIGINS = True

# --- Email Settings for Automated Communication ---
# For development, you can use console backend or a dummy backend
EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend' # Prints emails to console (for development)
# EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend' # For production

# If using SMTP (e.g., Gmail)
# EMAIL_HOST = 'smtp.gmail.com'
# EMAIL_PORT = 587
# EMAIL_USE_TLS = True
# EMAIL_HOST_USER = 'your_email@gmail.com'
# EMAIL_HOST_PASSWORD = 'your_email_password' # Use environment variables or app-specific passwords in production
DEFAULT_FROM_EMAIL = 'ahmed_fa@tatbigia.edu.sd' # Your university's official email address
SERVER_EMAIL = DEFAULT_FROM_EMAIL # For error reporting
REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': [
        'rest_framework.authentication.TokenAuthentication',
        'rest_framework.authentication.SessionAuthentication', # Use session auth
    ],
    'DEFAULT_PERMISSION_CLASSES': [
        'rest_framework.permissions.IsAuthenticated', # Default to requiring auth
    ]
}
# --- Media Files Settings ---
# URL that handles the media served from MEDIA_ROOT.
# Use to manage uploaded files.
MEDIA_URL = '/media/'

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = BASE_DIR / 'media' # This will create a 'media' folder in your project root
