# student_management/urls.py

from django.urls import path, include
from rest_framework.routers import DefaultRouter
from .views import StudentViewSet, SemesterEnrollmentViewSet, StudentRegistrationAPIView, ImportAcceptedStudentsAPIView, RegistrarActionsAPIView, PublicApplicationAPIView, ApplicationViewSet,PublicDepartmentsAPIView

router = DefaultRouter()
router.register(r'students', StudentViewSet)
router.register(r'semester-enrollments', SemesterEnrollmentViewSet)
router.register(r'applications', ApplicationViewSet)


urlpatterns = [
    path('', include(router.urls)),
    path('register-semester/', StudentRegistrationAPIView.as_view(), name='student-semester-registration'), # New API endpoint
    path('import-accepted-students/', ImportAcceptedStudentsAPIView.as_view(), name='import-accepted-students'), # New API
    path('registrar-actions/approve-documents/', RegistrarActionsAPIView.as_view(), name='registrar-approve-documents'),
        path('public-application/', PublicApplicationAPIView.as_view(), name='public-application'),
        path('public-departments/', PublicDepartmentsAPIView.as_view(), name='public-departments'),




]