# Generated by Django 4.2.23 on 2025-09-13 14:36

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ("university_structure", "0002_initial"),
        ("student_management", "0002_student_national_id"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="application",
            options={
                "ordering": ["-application_date"],
                "verbose_name": "طلب تقديم",
                "verbose_name_plural": "طلبات التقديم",
            },
        ),
        migrations.RemoveField(
            model_name="application",
            name="documents_uploaded",
        ),
        migrations.RemoveField(
            model_name="application",
            name="gpa",
        ),
        migrations.RemoveField(
            model_name="application",
            name="previous_school",
        ),
        migrations.RemoveField(
            model_name="application",
            name="status",
        ),
        migrations.AddField(
            model_name="application",
            name="application_fee_paid",
            field=models.BooleanField(
                default=False, verbose_name="تم دفع رسوم التقديم"
            ),
        ),
        migrations.AddField(
            model_name="application",
            name="application_status",
            field=models.CharField(
                choices=[
                    ("Pending", "قيد المراجعة"),
                    ("Accepted", "مقبول"),
                    ("Rejected", "مرفوض"),
                ],
                default="Pending",
                max_length=20,
                verbose_name="حالة الطلب",
            ),
        ),
        migrations.AddField(
            model_name="application",
            name="high_school_certificate_score",
            field=models.DecimalField(
                decimal_places=2,
                default=0,
                max_digits=5,
                verbose_name="درجة الشهادة الثانوية",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="application",
            name="high_school_graduation_year",
            field=models.IntegerField(
                default="2024", verbose_name="سنة التخرج من الثانوية"
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="application",
            name="desired_department",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="university_structure.department",
                verbose_name="القسم المطلوب",
            ),
        ),
        migrations.AlterField(
            model_name="application",
            name="first_name_ar",
            field=models.CharField(max_length=50, verbose_name="الاسم الأول (عربي)"),
        ),
        migrations.AlterField(
            model_name="application",
            name="first_name_en",
            field=models.CharField(max_length=50, verbose_name="First Name (English)"),
        ),
        migrations.AlterField(
            model_name="application",
            name="fourth_name_ar",
            field=models.CharField(max_length=50, verbose_name="الاسم الرابع (عربي)"),
        ),
        migrations.AlterField(
            model_name="application",
            name="fourth_name_en",
            field=models.CharField(max_length=50, verbose_name="Fourth Name (English)"),
        ),
        migrations.AlterField(
            model_name="application",
            name="gender",
            field=models.CharField(
                choices=[("Male", "ذكر"), ("Female", "أنثى"), ("Other", "أخرى")],
                max_length=10,
                verbose_name="النوع",
            ),
        ),
        migrations.AlterField(
            model_name="application",
            name="nationality",
            field=models.CharField(max_length=50, verbose_name="الجنسية"),
        ),
        migrations.AlterField(
            model_name="application",
            name="second_name_ar",
            field=models.CharField(
                blank=True, max_length=50, null=True, verbose_name="الاسم الثاني (عربي)"
            ),
        ),
        migrations.AlterField(
            model_name="application",
            name="second_name_en",
            field=models.CharField(
                blank=True,
                max_length=50,
                null=True,
                verbose_name="Second Name (English)",
            ),
        ),
        migrations.AlterField(
            model_name="application",
            name="third_name_ar",
            field=models.CharField(
                blank=True, max_length=50, null=True, verbose_name="الاسم الثالث (عربي)"
            ),
        ),
        migrations.AlterField(
            model_name="application",
            name="third_name_en",
            field=models.CharField(
                blank=True,
                max_length=50,
                null=True,
                verbose_name="Third Name (English)",
            ),
        ),
    ]
