# Generated by Django 4.2.23 on 2025-07-21 15:06

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("university_structure", "0002_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Student",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "student_id",
                    models.CharField(
                        blank=True,
                        max_length=20,
                        null=True,
                        unique=True,
                        verbose_name="الرقم الجامعي",
                    ),
                ),
                (
                    "first_name_ar",
                    models.CharField(max_length=100, verbose_name="الاسم الأول (عربي)"),
                ),
                (
                    "second_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الثاني (عربي)"
                    ),
                ),
                (
                    "third_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الثالث (عربي)"
                    ),
                ),
                (
                    "fourth_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الرابع (عربي)"
                    ),
                ),
                (
                    "first_name_en",
                    models.CharField(
                        max_length=100, verbose_name="First Name (English)"
                    ),
                ),
                (
                    "second_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Second Name (English)"
                    ),
                ),
                (
                    "third_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Third Name (English)"
                    ),
                ),
                (
                    "fourth_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Fourth Name (English)"
                    ),
                ),
                (
                    "date_of_birth",
                    models.DateField(
                        blank=True, null=True, verbose_name="تاريخ الميلاد"
                    ),
                ),
                (
                    "gender",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Male", "ذكر"),
                            ("Female", "أنثى"),
                            ("Other", "أخرى"),
                        ],
                        max_length=10,
                        null=True,
                        verbose_name="الجنس",
                    ),
                ),
                (
                    "nationality",
                    models.CharField(
                        blank=True, max_length=100, null=True, verbose_name="الجنسية"
                    ),
                ),
                (
                    "contact_email",
                    models.EmailField(
                        max_length=254,
                        unique=True,
                        verbose_name="البريد الإلكتروني للاتصال",
                    ),
                ),
                (
                    "contact_phone",
                    models.CharField(
                        blank=True, max_length=20, null=True, verbose_name="رقم الهاتف"
                    ),
                ),
                (
                    "address",
                    models.TextField(blank=True, null=True, verbose_name="العنوان"),
                ),
                (
                    "admission_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="تاريخ القبول الأولي"
                    ),
                ),
                (
                    "admission_source",
                    models.CharField(
                        default="Ministry", max_length=50, verbose_name="مصدر القبول"
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("Provisional", "مقبول مبدئياً"),
                            ("Active", "طالب حالي"),
                            ("Inactive", "غير نشط"),
                            ("Graduated", "متخرج"),
                            ("Suspended", "موقوف"),
                            ("Expelled", "مفصول"),
                            ("On Leave", "في إجازة"),
                            ("Withdrawn", "منسحب"),
                            ("Rejected", "مرفوض"),
                        ],
                        default="Provisional",
                        max_length=20,
                        verbose_name="حالة الطالب",
                    ),
                ),
                (
                    "id_card_uploaded",
                    models.BooleanField(default=False, verbose_name="تم رفع الهوية"),
                ),
                (
                    "high_school_cert_uploaded",
                    models.BooleanField(
                        default=False, verbose_name="تم رفع شهادة الثانوية"
                    ),
                ),
                (
                    "personal_photo_uploaded",
                    models.BooleanField(
                        default=False, verbose_name="تم رفع الصورة الشخصية"
                    ),
                ),
                (
                    "documents_approved",
                    models.BooleanField(
                        default=False, verbose_name="تم اعتماد المستندات"
                    ),
                ),
                (
                    "academic_level",
                    models.PositiveSmallIntegerField(
                        default=0, verbose_name="المستوى الأكاديمي الحالي"
                    ),
                ),
                (
                    "is_registered_for_current_semester",
                    models.BooleanField(
                        default=False, verbose_name="مسجل للفصل الحالي"
                    ),
                ),
                (
                    "batch",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="students",
                        to="university_structure.batch",
                        verbose_name="الدفعة",
                    ),
                ),
                (
                    "current_academic_semester",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="students_in_semester",
                        to="university_structure.academicsemester",
                        verbose_name="الفصل الدراسي الحالي",
                    ),
                ),
                (
                    "current_academic_year",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="students_in_year",
                        to="university_structure.academicyear",
                        verbose_name="السنة الأكاديمية الحالية",
                    ),
                ),
                (
                    "department",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="students",
                        to="university_structure.department",
                        verbose_name="القسم",
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="student_profile",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="حساب المستخدم",
                    ),
                ),
            ],
            options={
                "verbose_name": "طالب",
                "verbose_name_plural": "الطلاب",
            },
        ),
        migrations.CreateModel(
            name="Application",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "first_name_ar",
                    models.CharField(max_length=100, verbose_name="الاسم الأول (عربي)"),
                ),
                (
                    "second_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الثاني (عربي)"
                    ),
                ),
                (
                    "third_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الثالث (عربي)"
                    ),
                ),
                (
                    "fourth_name_ar",
                    models.CharField(
                        max_length=100, verbose_name="الاسم الرابع (عربي)"
                    ),
                ),
                (
                    "first_name_en",
                    models.CharField(
                        max_length=100, verbose_name="First Name (English)"
                    ),
                ),
                (
                    "second_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Second Name (English)"
                    ),
                ),
                (
                    "third_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Third Name (English)"
                    ),
                ),
                (
                    "fourth_name_en",
                    models.CharField(
                        max_length=100, verbose_name="Fourth Name (English)"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        max_length=254, unique=True, verbose_name="البريد الإلكتروني"
                    ),
                ),
                (
                    "phone_number",
                    models.CharField(
                        blank=True, max_length=20, null=True, verbose_name="رقم الهاتف"
                    ),
                ),
                ("date_of_birth", models.DateField(verbose_name="تاريخ الميلاد")),
                (
                    "gender",
                    models.CharField(
                        choices=[("Male", "ذكر"), ("Female", "أنثى")],
                        max_length=10,
                        verbose_name="النوع",
                    ),
                ),
                (
                    "nationality",
                    models.CharField(max_length=100, verbose_name="الجنسية"),
                ),
                (
                    "address",
                    models.TextField(blank=True, null=True, verbose_name="العنوان"),
                ),
                (
                    "previous_school",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="المدرسة السابقة",
                    ),
                ),
                (
                    "gpa",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=4,
                        null=True,
                        verbose_name="المعدل التراكمي السابق",
                    ),
                ),
                (
                    "application_date",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="تاريخ التقديم"
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("Pending", "قيد المراجعة"),
                            ("Under Review", "تحت المراجعة"),
                            ("Accepted", "مقبول"),
                            ("Rejected", "مرفوض"),
                            ("Withdrawn", "منسحب"),
                        ],
                        default="Pending",
                        max_length=20,
                        verbose_name="حالة الطلب",
                    ),
                ),
                (
                    "documents_uploaded",
                    models.BooleanField(default=False, verbose_name="تم رفع المستندات"),
                ),
                (
                    "desired_department",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="applications",
                        to="university_structure.department",
                        verbose_name="القسم المطلوب",
                    ),
                ),
            ],
            options={
                "verbose_name": "طلب تقديم",
                "verbose_name_plural": "طلبات التقديم",
            },
        ),
        migrations.CreateModel(
            name="AdmissionDecision",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "decision",
                    models.CharField(
                        choices=[
                            ("Accepted", "مقبول"),
                            ("Rejected", "مرفوض"),
                            ("Waitlisted", "قائمة الانتظار"),
                        ],
                        max_length=20,
                        verbose_name="القرار",
                    ),
                ),
                (
                    "decision_date",
                    models.DateField(auto_now_add=True, verbose_name="تاريخ القرار"),
                ),
                (
                    "notes",
                    models.TextField(blank=True, null=True, verbose_name="ملاحظات"),
                ),
                (
                    "admitted_student",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="student_management.student",
                        verbose_name="الطالب المقبول",
                    ),
                ),
                (
                    "admitted_to_batch",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="university_structure.batch",
                        verbose_name="القبول بدفعة",
                    ),
                ),
                (
                    "admitted_to_department",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="university_structure.department",
                        verbose_name="القبول بقسم",
                    ),
                ),
                (
                    "application",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="admission_decision",
                        to="student_management.application",
                        verbose_name="طلب التقديم",
                    ),
                ),
            ],
            options={
                "verbose_name": "قرار قبول",
                "verbose_name_plural": "قرارات القبول",
            },
        ),
        migrations.CreateModel(
            name="SemesterEnrollment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "enrollment_date",
                    models.DateField(auto_now_add=True, verbose_name="تاريخ التسجيل"),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="نشط في هذا الفصل"),
                ),
                (
                    "fees_paid",
                    models.BooleanField(default=False, verbose_name="تم دفع الرسوم"),
                ),
                (
                    "academic_semester",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="university_structure.academicsemester",
                        verbose_name="الفصل الدراسي",
                    ),
                ),
                (
                    "academic_year",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="university_structure.academicyear",
                        verbose_name="السنة الأكاديمية",
                    ),
                ),
                (
                    "student",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="enrollments",
                        to="student_management.student",
                        verbose_name="الطالب",
                    ),
                ),
            ],
            options={
                "verbose_name": "تسجيل فصلي",
                "verbose_name_plural": "تسجيلات فصلية",
                "unique_together": {("student", "academic_semester")},
            },
        ),
    ]
