# finance_management/urls.py

from django.urls import path, include
from rest_framework.routers import DefaultRouter
from .views import FeeTypeViewSet, FeeStructureViewSet, StudentInvoiceViewSet, InvoiceItemViewSet, StudentPaymentViewSet, PaymentUploadAPIView, ApprovePaymentAPIView, StaffRecordPaymentAPIView , GenerateInvoicesAPIView,  ManualInvoiceCreateAPIView

router = DefaultRouter()
router.register(r'fee-types', FeeTypeViewSet)
router.register(r'fee-structures', FeeStructureViewSet)
router.register(r'student-invoices', StudentInvoiceViewSet)
router.register(r'invoice-items', InvoiceItemViewSet)
router.register(r'student-payments', StudentPaymentViewSet)

urlpatterns = [
    path('', include(router.urls)),
    path('payments/upload-receipt/', PaymentUploadAPIView.as_view(), name='payment-upload-receipt'), # New API endpoint
    path('payments/approve/', ApprovePaymentAPIView.as_view(), name='payment-approve'), # New API endpoint
    path('payments/record-staff/', StaffRecordPaymentAPIView.as_view(), name='payment-record-staff'), 
    path('invoices/generate/', GenerateInvoicesAPIView.as_view(), name='generate-invoices'), 
    path('invoices/manual-create/', ManualInvoiceCreateAPIView.as_view(), name='manual-invoice-create'),



]