# Generated by Django 4.2.23 on 2025-07-21 15:06

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("university_structure", "0002_initial"),
        ("users", "0001_initial"),
        ("student_management", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="FeeType",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name_ar",
                    models.CharField(
                        max_length=100,
                        unique=True,
                        verbose_name="اسم نوع الرسوم (عربي)",
                    ),
                ),
                (
                    "name_en",
                    models.CharField(
                        max_length=100,
                        unique=True,
                        verbose_name="Fee Type Name (English)",
                    ),
                ),
                (
                    "description_ar",
                    models.TextField(blank=True, verbose_name="الوصف (عربي)"),
                ),
                ("is_active", models.BooleanField(default=True, verbose_name="نشط")),
            ],
            options={
                "verbose_name": "نوع الرسوم",
                "verbose_name_plural": "أنواع الرسوم",
            },
        ),
        migrations.CreateModel(
            name="StudentInvoice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "invoice_number",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="رقم الفاتورة"
                    ),
                ),
                (
                    "total_amount",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="المبلغ الإجمالي"
                    ),
                ),
                ("due_date", models.DateField(verbose_name="تاريخ الاستحقاق")),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("Pending", "معلقة"),
                            ("Paid", "مدفوعة"),
                            ("Partially Paid", "مدفوعة جزئياً"),
                            ("Overdue", "متأخرة"),
                            ("Cancelled", "ملغاة"),
                        ],
                        default="Pending",
                        max_length=20,
                        verbose_name="الحالة",
                    ),
                ),
                (
                    "generated_at",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="تاريخ الإنشاء"
                    ),
                ),
                (
                    "academic_semester",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="university_structure.academicsemester",
                        verbose_name="الفصل الدراسي",
                    ),
                ),
                (
                    "academic_year",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="university_structure.academicyear",
                        verbose_name="السنة الأكاديمية",
                    ),
                ),
                (
                    "student",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="invoices",
                        to="student_management.student",
                        verbose_name="الطالب",
                    ),
                ),
            ],
            options={
                "verbose_name": "فاتورة طالب",
                "verbose_name_plural": "فواتير الطلاب",
            },
        ),
        migrations.CreateModel(
            name="StudentPayment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="المبلغ المدفوع"
                    ),
                ),
                (
                    "payment_date",
                    models.DateTimeField(auto_now_add=True, verbose_name="تاريخ الدفع"),
                ),
                (
                    "payment_method",
                    models.CharField(
                        choices=[
                            ("Cash", "نقداً"),
                            ("Bank Transfer", "تحويل بنكي"),
                            ("Online", "دفع إلكتروني"),
                            ("Other", "أخرى"),
                        ],
                        max_length=20,
                        verbose_name="طريقة الدفع",
                    ),
                ),
                (
                    "reference_number",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        unique=True,
                        verbose_name="الرقم المرجعي",
                    ),
                ),
                (
                    "invoice",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payments",
                        to="finance_management.studentinvoice",
                        verbose_name="الفاتورة",
                    ),
                ),
                (
                    "received_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="users.facultyprofile",
                        verbose_name="استلمها الموظف",
                    ),
                ),
            ],
            options={
                "verbose_name": "دفعة طالب",
                "verbose_name_plural": "دفعات الطلاب",
                "ordering": ["-payment_date"],
            },
        ),
        migrations.CreateModel(
            name="InvoiceItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="المبلغ"
                    ),
                ),
                (
                    "description_ar",
                    models.TextField(blank=True, verbose_name="الوصف (عربي)"),
                ),
                (
                    "fee_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="finance_management.feetype",
                        verbose_name="نوع الرسوم",
                    ),
                ),
                (
                    "invoice",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="items",
                        to="finance_management.studentinvoice",
                        verbose_name="الفاتورة",
                    ),
                ),
            ],
            options={
                "verbose_name": "بند فاتورة",
                "verbose_name_plural": "بنود الفواتير",
            },
        ),
        migrations.CreateModel(
            name="FeeStructure",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="المبلغ"
                    ),
                ),
                (
                    "academic_semester",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="university_structure.academicsemester",
                        verbose_name="الفصل الدراسي",
                    ),
                ),
                (
                    "academic_year",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="university_structure.academicyear",
                        verbose_name="السنة الأكاديمية",
                    ),
                ),
                (
                    "batch",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="university_structure.batch",
                        verbose_name="الدفعة",
                    ),
                ),
                (
                    "department",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="university_structure.department",
                        verbose_name="القسم",
                    ),
                ),
                (
                    "fee_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="structures",
                        to="finance_management.feetype",
                        verbose_name="نوع الرسوم",
                    ),
                ),
            ],
            options={
                "verbose_name": "هيكل الرسوم",
                "verbose_name_plural": "هياكل الرسوم",
                "unique_together": {
                    (
                        "fee_type",
                        "academic_year",
                        "academic_semester",
                        "department",
                        "batch",
                    )
                },
            },
        ),
    ]
