# examination_management/views.py

from rest_framework import viewsets
from .models import GradeEntry, SemesterResult, OverallResult, StudentCourseResult
from .serializers import (
    GradeEntrySerializer, SemesterResultSerializer,
    OverallResultSerializer, StudentCourseResultSerializer
)

class GradeEntryViewSet(viewsets.ModelViewSet):
    queryset = GradeEntry.objects.all().order_by('-entry_date')
    serializer_class = GradeEntrySerializer
    # Filters could be added here, e.g., to filter by student, course_offering, or faculty

class SemesterResultViewSet(viewsets.ModelViewSet):
    queryset = SemesterResult.objects.all().order_by('-academic_year__year', '-academic_semester__semester_number', 'student__fourth_name_ar')
    serializer_class = SemesterResultSerializer
    # Filters could be added, e.g., by academic_year, semester, student, or status

class OverallResultViewSet(viewsets.ModelViewSet):
    queryset = OverallResult.objects.all().order_by('student__fourth_name_ar')
    serializer_class = OverallResultSerializer
    # Filters could be added, e.g., by student or graduation status

class StudentCourseResultViewSet(viewsets.ModelViewSet):
    queryset = StudentCourseResult.objects.all().order_by('academic_semester__academic_year__year', 'academic_semester__semester_number', 'student__fourth_name_ar', 'course__code')
    serializer_class = StudentCourseResultSerializer
    # Filters could be added, e.g., by student, course, or pass/fail status