# examination_management/urls.py

from django.urls import path, include
from rest_framework.routers import DefaultRouter
from .views import (
    GradeEntryViewSet, SemesterResultViewSet, OverallResultViewSet, StudentCourseResultViewSet
)

router = DefaultRouter()
router.register(r'grade-entries', GradeEntryViewSet)
router.register(r'semester-results', SemesterResultViewSet)
router.register(r'overall-results', OverallResultViewSet)
router.register(r'student-course-results', StudentCourseResultViewSet)

urlpatterns = [
    path('', include(router.urls)),
]