# examination_management/serializers.py

from rest_framework import serializers
from .models import GradeEntry, SemesterResult, OverallResult, StudentCourseResult
from student_management.models import Student
from course_management.models import Course, CourseOffering
from university_structure.models import AcademicYear, AcademicSemester
from users.models import FacultyProfile

class GradeEntrySerializer(serializers.ModelSerializer): # Moved up for nesting
    student_full_name_ar = serializers.SerializerMethodField()
    course_offering_code = serializers.CharField(source='course_offering.course.code', read_only=True)
    entered_by_full_name_ar = serializers.SerializerMethodField()

    class Meta:
        model = GradeEntry
        fields = '__all__'

    def get_student_full_name_ar(self, obj):
        return f"{obj.student.first_name_ar} {obj.student.second_name_ar} {obj.student.third_name_ar} {obj.student.fourth_name_ar}"

    def get_entered_by_full_name_ar(self, obj):
        if obj.entered_by:
            return f"{obj.entered_by.first_name_ar} {obj.entered_by.second_name_ar} {obj.entered_by.third_name_ar} {obj.entered_by.fourth_name_ar}"
        return None

class StudentCourseResultSerializer(serializers.ModelSerializer): # Moved up for nesting
    student_full_name_ar = serializers.SerializerMethodField()
    course_code = serializers.CharField(source='course.code', read_only=True)
    course_title_ar = serializers.CharField(source='course.title_ar', read_only=True)
    academic_semester_name_ar = serializers.CharField(source='academic_semester.name_ar', read_only=True)
    status_display = serializers.CharField(source='get_status_display', read_only=True)

    class Meta:
        model = StudentCourseResult
        fields = '__all__'

    def get_student_full_name_ar(self, obj):
        return f"{obj.student.first_name_ar} {obj.student.second_name_ar} {obj.student.third_name_ar} {obj.student.fourth_name_ar}"

class SemesterResultSerializer(serializers.ModelSerializer):
    student_full_name_ar = serializers.SerializerMethodField()
    academic_year_name = serializers.CharField(source='academic_year.year', read_only=True)
    academic_semester_name_ar = serializers.CharField(source='academic_semester.name_ar', read_only=True)
    approved_by_hod_name = serializers.SerializerMethodField()
    approved_by_committee_member_name = serializers.SerializerMethodField()
    status_display = serializers.CharField(source='get_status_display', read_only=True)

    # Nested course results for this semester
    individual_course_results = StudentCourseResultSerializer(many=True, read_only=True)

    class Meta:
        model = SemesterResult
        fields = '__all__'

    def get_student_full_name_ar(self, obj):
        return f"{obj.student.first_name_ar} {obj.student.second_name_ar} {obj.student.third_name_ar} {obj.student.fourth_name_ar}"

    def get_approved_by_hod_name(self, obj):
        if obj.approved_by_hod:
            return f"{obj.approved_by_hod.first_name_ar} {obj.approved_by_hod.fourth_name_ar}"
        return None

    def get_approved_by_committee_member_name(self, obj):
        if obj.approved_by_committee_member:
            return f"{obj.approved_by_committee_member.first_name_ar} {obj.approved_by_committee_member.fourth_name_ar}"
        return None


class OverallResultSerializer(serializers.ModelSerializer):
    student_full_name_ar = serializers.SerializerMethodField()
    academic_standing_display = serializers.CharField(source='get_academic_standing_display', read_only=True)

    class Meta:
        model = OverallResult
        fields = '__all__'

    def get_student_full_name_ar(self, obj):
        return f"{obj.student.first_name_ar} {obj.student.second_name_ar} {obj.student.third_name_ar} {obj.student.fourth_name_ar}"