# Generated by Django 4.2.23 on 2025-07-21 15:06

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("university_structure", "0002_initial"),
        ("student_management", "0001_initial"),
        ("course_management", "0001_initial"),
        ("users", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="SemesterResult",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "gpa",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=4,
                        null=True,
                        verbose_name="المعدل الفصلي (GPA)",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("Pending", "قيد المراجعة"),
                            ("HOD Approved", "اعتماد رئيس القسم"),
                            ("Committee Approved", "اعتماد لجنة الجامعة"),
                            ("Published", "منشورة"),
                            ("Archived", "مؤرشفة"),
                        ],
                        default="Pending",
                        max_length=20,
                        verbose_name="حالة النتيجة",
                    ),
                ),
                (
                    "publication_date",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="تاريخ النشر"
                    ),
                ),
                (
                    "is_locked",
                    models.BooleanField(
                        default=False, verbose_name="مقفلة (غير قابلة للتعديل)"
                    ),
                ),
                (
                    "academic_semester",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="university_structure.academicsemester",
                        verbose_name="الفصل الدراسي",
                    ),
                ),
                (
                    "academic_year",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="university_structure.academicyear",
                        verbose_name="السنة الأكاديمية",
                    ),
                ),
                (
                    "approved_by_committee_member",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="results_approved_as_committee",
                        to="users.facultyprofile",
                        verbose_name="اعتماد لجنة الجامعة",
                    ),
                ),
                (
                    "approved_by_hod",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="results_approved_as_hod",
                        to="users.facultyprofile",
                        verbose_name="اعتماد رئيس القسم",
                    ),
                ),
                (
                    "student",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="semester_results",
                        to="student_management.student",
                        verbose_name="الطالب",
                    ),
                ),
            ],
            options={
                "verbose_name": "نتيجة فصلية",
                "verbose_name_plural": "النتائج الفصلية",
                "ordering": [
                    "-academic_year__year",
                    "-academic_semester__semester_number",
                    "student__fourth_name_ar",
                ],
                "unique_together": {("student", "academic_semester")},
            },
        ),
        migrations.CreateModel(
            name="OverallResult",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "cgpa",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=4,
                        null=True,
                        verbose_name="المعدل التراكمي (CGPA)",
                    ),
                ),
                (
                    "academic_standing",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="الوضع الأكاديمي",
                    ),
                ),
                (
                    "total_credits_earned",
                    models.DecimalField(
                        decimal_places=1,
                        default=0.0,
                        max_digits=5,
                        verbose_name="إجمالي الساعات المعتمدة المكتسبة",
                    ),
                ),
                (
                    "is_graduated",
                    models.BooleanField(default=False, verbose_name="متخرج"),
                ),
                (
                    "graduation_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="تاريخ التخرج"
                    ),
                ),
                (
                    "student",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="overall_result",
                        to="student_management.student",
                        verbose_name="الطالب",
                    ),
                ),
            ],
            options={
                "verbose_name": "نتيجة شاملة",
                "verbose_name_plural": "النتائج الشاملة",
            },
        ),
        migrations.CreateModel(
            name="StudentCourseResult",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "final_score",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=5,
                        null=True,
                        verbose_name="الدرجة النهائية",
                    ),
                ),
                (
                    "final_letter_grade",
                    models.CharField(
                        blank=True,
                        max_length=5,
                        null=True,
                        verbose_name="التقدير النهائي",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("Pass", "ناجح"),
                            ("Fail", "راسب"),
                            ("Incomplete", "غير مكتمل"),
                        ],
                        max_length=10,
                        verbose_name="الحالة في المقرر",
                    ),
                ),
                (
                    "academic_semester",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="university_structure.academicsemester",
                        verbose_name="الفصل الدراسي",
                    ),
                ),
                (
                    "course",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="course_management.course",
                        verbose_name="المقرر الدراسي",
                    ),
                ),
                (
                    "semester_result",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="individual_course_results",
                        to="examination_management.semesterresult",
                        verbose_name="النتيجة الفصلية",
                    ),
                ),
                (
                    "student",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="course_results",
                        to="student_management.student",
                        verbose_name="الطالب",
                    ),
                ),
            ],
            options={
                "verbose_name": "نتيجة مقرر الطالب",
                "verbose_name_plural": "نتائج مقررات الطلاب",
                "ordering": ["student", "academic_semester", "course__code"],
                "unique_together": {("student", "course", "academic_semester")},
            },
        ),
        migrations.CreateModel(
            name="GradeEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "score",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=5,
                        null=True,
                        verbose_name="الدرجة/النقاط",
                    ),
                ),
                (
                    "letter_grade",
                    models.CharField(
                        blank=True,
                        max_length=5,
                        null=True,
                        verbose_name="التقدير الحرفي",
                    ),
                ),
                (
                    "entry_date",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="تاريخ الإدخال"
                    ),
                ),
                (
                    "course_offering",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="grades_recorded",
                        to="course_management.courseoffering",
                        verbose_name="طرح المقرر",
                    ),
                ),
                (
                    "entered_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="users.facultyprofile",
                        verbose_name="أدخلها الأستاذ",
                    ),
                ),
                (
                    "student",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="grades_entered",
                        to="student_management.student",
                        verbose_name="الطالب",
                    ),
                ),
            ],
            options={
                "verbose_name": "إدخال درجة",
                "verbose_name_plural": "إدخالات الدرجات",
                "unique_together": {("student", "course_offering")},
            },
        ),
    ]
