# course_management/views.py

from rest_framework import viewsets
from rest_framework.permissions import IsAuthenticated # Assuming these views require authentication
from django_filters.rest_framework import DjangoFilterBackend
from rest_framework import filters
from django.utils.translation import gettext_lazy as _

from .models import Course, ProgramCourse, CourseOffering
from .serializers import CourseSerializer, ProgramCourseSerializer, CourseOfferingSerializer

class CourseViewSet(viewsets.ModelViewSet):
    queryset = Course.objects.all().order_by('code')
    serializer_class = CourseSerializer
    permission_classes = [IsAuthenticated]
    filter_backends = [DjangoFilterBackend, filters.SearchFilter]
    filterset_fields = ['department']
    search_fields = ['code', 'title_ar', 'title_en']

class ProgramCourseViewSet(viewsets.ModelViewSet):
    queryset = ProgramCourse.objects.all().order_by('department__name_ar', 'academic_year_level', 'semester_number')
    serializer_class = ProgramCourseSerializer
    permission_classes = [IsAuthenticated]
    filter_backends = [DjangoFilterBackend]
    filterset_fields = ['department', 'academic_year_level', 'semester_number', 'course']

class CourseOfferingViewSet(viewsets.ModelViewSet):
    queryset = CourseOffering.objects.all().order_by('academic_semester__academic_year__year', 'academic_semester__semester_number', 'course__code')
    serializer_class = CourseOfferingSerializer
    permission_classes = [IsAuthenticated]
    filter_backends = [DjangoFilterBackend, filters.SearchFilter]
    filterset_fields = ['course', 'academic_semester', 'faculty']
    search_fields = ['section_name', 'room_number', 'course__code', 'course__title_ar']