# course_management/serializers.py

from rest_framework import serializers
from .models import Course, ProgramCourse, CourseOffering
from university_structure.models import Department, AcademicYear, AcademicSemester
from users.models import FacultyProfile

class CourseSerializer(serializers.ModelSerializer):
    department_name_ar = serializers.CharField(source='department.name_ar', read_only=True, allow_null=True)
    department_name_en = serializers.CharField(source='department.name_en', read_only=True, allow_null=True)

    # Nested prerequisites (optional, for display)
    # prerequisites_details = serializers.SerializerMethodField()

    class Meta:
        model = Course
        fields = '__all__'

    # def get_prerequisites_details(self, obj):
    #     # This would fetch details of prerequisite courses
    #     # return [{'id': p.id, 'code': p.code, 'title_ar': p.title_ar} for p in obj.prerequisites.all()]
    #     return None # For now, keep it simple

class ProgramCourseSerializer(serializers.ModelSerializer):
    department_name_ar = serializers.CharField(source='department.name_ar', read_only=True)
    course_code = serializers.CharField(source='course.code', read_only=True)
    course_title_ar = serializers.CharField(source='course.title_ar', read_only=True)
    academic_year_name = serializers.CharField(source='academic_year.year', read_only=True)
    academic_semester_name_ar = serializers.CharField(source='academic_semester.name_ar', read_only=True)

    class Meta:
        model = ProgramCourse
        fields = '__all__'

class CourseOfferingSerializer(serializers.ModelSerializer):
    course_code = serializers.CharField(source='course.code', read_only=True)
    course_title_ar = serializers.CharField(source='course.title_ar', read_only=True)
    academic_semester_name_ar = serializers.CharField(source='academic_semester.name_ar', read_only=True)
    academic_year_name = serializers.CharField(source='academic_semester.academic_year.year', read_only=True)
    faculty_full_name_ar = serializers.CharField(source='faculty.full_name_ar', read_only=True, allow_null=True)

    class Meta:
        model = CourseOffering
        fields = '__all__'