# Generated by Django 4.2.23 on 2025-07-21 15:06

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("university_structure", "0002_initial"),
        ("users", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Course",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        max_length=20, unique=True, verbose_name="كود المقرر"
                    ),
                ),
                (
                    "title_ar",
                    models.CharField(
                        max_length=255, verbose_name="عنوان المقرر (عربي)"
                    ),
                ),
                (
                    "title_en",
                    models.CharField(
                        max_length=255, verbose_name="Course Title (English)"
                    ),
                ),
                (
                    "description_ar",
                    models.TextField(blank=True, verbose_name="الوصف (عربي)"),
                ),
                (
                    "credits",
                    models.DecimalField(
                        decimal_places=1,
                        max_digits=3,
                        verbose_name="عدد الساعات المعتمدة",
                    ),
                ),
                (
                    "department",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="courses",
                        to="university_structure.department",
                        verbose_name="القسم المسؤول",
                    ),
                ),
                (
                    "prerequisites",
                    models.ManyToManyField(
                        blank=True,
                        related_name="required_for",
                        to="course_management.course",
                        verbose_name="المتطلبات السابقة",
                    ),
                ),
            ],
            options={
                "verbose_name": "مقرر دراسي",
                "verbose_name_plural": "المقررات الدراسية",
            },
        ),
        migrations.CreateModel(
            name="ProgramCourse",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "academic_year_level",
                    models.IntegerField(
                        verbose_name="المستوى الدراسي/السنة الأكاديمية"
                    ),
                ),
                (
                    "semester_number",
                    models.IntegerField(verbose_name="رقم الفصل الدراسي"),
                ),
                (
                    "course",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="program_definitions",
                        to="course_management.course",
                        verbose_name="المقرر الدراسي",
                    ),
                ),
                (
                    "department",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="program_courses",
                        to="university_structure.department",
                        verbose_name="القسم",
                    ),
                ),
            ],
            options={
                "verbose_name": "مقرر ضمن الخطة",
                "verbose_name_plural": "مقررات ضمن الخطة",
                "ordering": [
                    "department",
                    "academic_year_level",
                    "semester_number",
                    "course__code",
                ],
                "unique_together": {
                    ("department", "course", "academic_year_level", "semester_number")
                },
            },
        ),
        migrations.CreateModel(
            name="CourseOffering",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "section_name",
                    models.CharField(
                        blank=True, max_length=50, verbose_name="اسم الشعبة (إن وجد)"
                    ),
                ),
                (
                    "start_time",
                    models.TimeField(blank=True, null=True, verbose_name="وقت البدء"),
                ),
                (
                    "end_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="وقت الانتهاء"
                    ),
                ),
                (
                    "days_of_week",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        verbose_name="أيام الأسبوع (مثال: MWF)",
                    ),
                ),
                (
                    "room_number",
                    models.CharField(
                        blank=True, max_length=50, verbose_name="رقم القاعة/المعمل"
                    ),
                ),
                (
                    "capacity",
                    models.PositiveIntegerField(
                        default=0, verbose_name="السعة القصوى للطلاب"
                    ),
                ),
                (
                    "academic_semester",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="course_offerings",
                        to="university_structure.academicsemester",
                        verbose_name="الفصل الدراسي",
                    ),
                ),
                (
                    "course",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="offerings",
                        to="course_management.course",
                        verbose_name="المقرر الدراسي",
                    ),
                ),
                (
                    "faculty",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="course_assignments",
                        to="users.facultyprofile",
                        verbose_name="أستاذ المقرر",
                    ),
                ),
            ],
            options={
                "verbose_name": "طرح مقرر",
                "verbose_name_plural": "طروحات المقررات",
                "unique_together": {("course", "academic_semester", "section_name")},
            },
        ),
    ]
